#include "triangleApp.h"



triangleApp::triangleApp(){
	
	
}


void triangleApp::init(){
	
	
	
	IT  = new imageTexture(1024,512, GL_RGB);  //big enough for 640 by 480
	IT2 = new imageTexture(1024,512, GL_RGB);  //big enough for 640 by 480	
	
	videoInput::listDevices();					  //static so we can decide whether to try and capture or not
	
	VI  = new videoInput();
	VI  ->setPhyCon(0,VI_COMPOSITE);
	VI  ->setCaptureSize(0,320,240);			  //Only use if you need a different size than the default
	VI  ->setCaptureSize(1,320,240);			  //Only use if you need a different size than the default
	VI  ->setup(2); //try to setup two cameras.


	frame   = new unsigned char[VI->getSize(0)]; //set the buffer to the size we are capturing at
	frame2  = new unsigned char[VI->getSize(1)]; //set the buffer to the size we are capturing at

}

void triangleApp::idle(){
	
	if(VI->grabFrame(0, frame)){
		IT->loadImageData(frame, VI->getWidth(0), VI->getHeight(0), GL_RGB); //use VI->width etc so that you don't get a crash
	}	
	
	if(VI->grabFrame(1, frame2)){
		IT2->loadImageData(frame2, VI->getWidth(1), VI->getHeight(1), GL_RGB); //use VI->width etc so that you don't get a crash
	}
}




void triangleApp::draw(){
  
	setupScreen();

	IT2->renderTexture(0,240, VI->getWidth(1), VI->getHeight(1));
	IT->renderTexture(320,240, VI->getWidth(0), VI->getHeight(0));
	IT2->renderTexture(320,0, VI->getWidth(1), VI->getHeight(1));
	IT->renderTexture(0,0, VI->getWidth(0), VI->getHeight(0));
}

void triangleApp::keyDown  (char c){

	if(c=='S')
	{
		VI->showSettingsWindow(0);
		VI->showSettingsWindow(1);

	}

}

void triangleApp::mouseMove( float x, float y ){


}

void triangleApp::mouseDrag( float x, float y ){

}

void triangleApp::mouseDown( float x, float y, int button ){

}

void triangleApp::mouseUp  ( float x, float y, int button ){

}


