#include "videoInput.h"

//Include Directshow stuff here so we don't worry about needing all the h files.

#include "DShow.h"
#include "streams.h"
#include "atlbase.h"
#include "qedit.h"
#include "dxutil.h"
#include "vector"




videoInput::videoInput()
{

    comInit = false;
   
    // Initialize the COM library.
    HRESULT hr = CoInitialize(NULL);
   
    if (FAILED(hr))
    {
	     // Well send our error messages to the console.
        printf("ERROR - Could not initialize COM library");
    }
    else{
    	comInit = true;
    }
    
    for(int i=0; i<MAX_CAMERAS; i++)
    {
    	VDList[i] = new videoDevice();
    }
        
    printf("\n***** VIDEOINPUT LIBRARY - 0.15 - TFW05 *****\n\n");
    
}

int videoInput::setup(int numDevices)
{


    int noOfFoundDevices = listDevicesPrivate();
 	if(numDevices>noOfFoundDevices)
    {
    	printf("SETUP: you specified %i devices,  only found %i devices\n", numDevices, noOfFoundDevices);
    	numDevices = noOfFoundDevices;
    }
    

    for(int i=0; i<numDevices; i++)
    {
    	start(i, VDList[i]);
	}
    
    devicesFound = numDevices;
    
    return devicesFound;
    
}


int videoInput::listDevices(){  

    //COM Library Intialization
	
	if(!comInit)
	{
		if(FAILED(CoInitialize(NULL))){
	        printf("ERROR: CoInitialize Failed! listDevices()\n");   
	    	return 0;
	    }
    }
    
    printf("\nVIDEOINPUT SPY MODE!\n\n");   
   
    
    	
	ICreateDevEnum *pDevEnum = NULL;
	IEnumMoniker *pEnum = NULL;	
	int deviceCounter = 0;
	WCHAR * deviceName;
	
	HRESULT hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL,
	    CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, 
	    reinterpret_cast<void**>(&pDevEnum));
	    
	    
	if (SUCCEEDED(hr))
	{
	    // Create an enumerator for the video capture category.
	    hr = pDevEnum->CreateClassEnumerator(
	    	CLSID_VideoInputDeviceCategory,
	        &pEnum, 0);
	        
	   if(hr == S_OK){
	   
			printf("SETUP: Looking For Capture Devices.\n");
			IMoniker *pMoniker = NULL;

			while (pEnum->Next(1, &pMoniker, NULL) == S_OK){
			    
			    IPropertyBag *pPropBag;
			    hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, 
			        (void**)(&pPropBag));
			        
			    if (FAILED(hr)){
			        pMoniker->Release();
			        continue;  // Skip this one, maybe the next one will work.
			    } 
			    
			    // Find the description or friendly name.
			    VARIANT varName;
			    VariantInit(&varName);
			    hr = pPropBag->Read(L"Description", &varName, 0);
			    
			    if (FAILED(hr)) hr = pPropBag->Read(L"FriendlyName", &varName, 0);
			  
			    if (SUCCEEDED(hr)){
			    
			    	hr = pPropBag->Read(L"FriendlyName", &varName, 0);
			     	
			     	int count = 0;
					char buffer[255];
					memset(buffer, 0, 255 * sizeof(char));
					
			        while( varName.bstrVal[count] != 0x00 ) {
			           buffer[count] = varName.bstrVal[count];
			           count++;
			         }
			                          
			        deviceName = new WCHAR[count];
			        memcpy(deviceName,buffer,sizeof(char)*(count));
			        printf("SETUP: %i) %s \n",deviceCounter, deviceName);
			        delete(deviceName);
		
			    }
			    pPropBag->Release();
			    pMoniker->Release();
			    deviceCounter++;

			}   

		}

	}
	
	printf("SETUP: %i Device(s) found\n\n", deviceCounter);
	
	if(!comInit)
	{
		CoUninitialize();
	}
	
	return deviceCounter;
		
}



int videoInput::listDevicesPrivate(){  

    	
	ICreateDevEnum *pDevEnum = NULL;
	IEnumMoniker *pEnum = NULL;	
	int deviceCounter = 0;
	WCHAR * deviceName;
	
	HRESULT hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL,
	    CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, 
	    reinterpret_cast<void**>(&pDevEnum));
	    
	    
	if (SUCCEEDED(hr))
	{
	    // Create an enumerator for the video capture category.
	    hr = pDevEnum->CreateClassEnumerator(
	    	CLSID_VideoInputDeviceCategory,
	        &pEnum, 0);
	        
	   if(hr == S_OK){
	   
			printf("SETUP: Looking For Capture Devices.\n");
			IMoniker *pMoniker = NULL;

			while (pEnum->Next(1, &pMoniker, NULL) == S_OK){
			    
			    IPropertyBag *pPropBag;
			    hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, 
			        (void**)(&pPropBag));
			        
			    if (FAILED(hr)){
			        pMoniker->Release();
			        continue;  // Skip this one, maybe the next one will work.
			    } 
			    
			    // Find the description or friendly name.
			    VARIANT varName;
			    VariantInit(&varName);
			    hr = pPropBag->Read(L"Description", &varName, 0);
			    
			    if (FAILED(hr)) hr = pPropBag->Read(L"FriendlyName", &varName, 0);
			  
			    if (SUCCEEDED(hr)){
			    
			    	hr = pPropBag->Read(L"FriendlyName", &varName, 0);
			     	
			     	int count = 0;
					char buffer[255];
					memset(buffer, 0, 255 * sizeof(char));
					
			        while( varName.bstrVal[count] != 0x00 ) {
			           buffer[count] = varName.bstrVal[count];
			           count++;
			         }
			                          
			        printf("SETUP: %i) %s \n",deviceCounter, buffer);
			        
			    }
			    pPropBag->Release();
			    pMoniker->Release();
			    deviceCounter++;

			}   

		}

	}
	
	printf("SETUP: %i Device(s) found\n\n", deviceCounter);
	return deviceCounter;
	
}




void videoInput::setPhyCon(int id, int conn){


	if(id<devicesFound)
	{
		switch(conn){
		
			case 0:
				VDList[id]->connection = PhysConn_Video_Composite;
				break;
			case 1:		
				VDList[id]->connection = PhysConn_Video_SVideo;
				break;
			case 2:
				VDList[id]->connection = PhysConn_Video_Tuner;
				break;
			case 3:
				VDList[id]->connection = PhysConn_Video_USB;
				break;	
			case 4:
				VDList[id]->connection = PhysConn_Video_1394;
				break;	
		}

		VDList[id]->useCrossbar=true;

	}

}




void videoInput::setCaptureSize(int id, int w, int h)
{
	
	if(id<devicesFound)
	{
		VDList[id] ->width       = w;
		VDList[id] ->height      = h;
		VDList[id] ->tryDiffSize = true;
	}
	
}

int videoInput::getWidth(int id)
{
	
	if(id<devicesFound)
	{
		return VDList[id] ->width;
	}
	
	return 0;
	
}

int videoInput::getHeight(int id)
{
	
	if(id<devicesFound)
	{
		return VDList[id] ->height;
	}
	
	return 0;
	
}


int videoInput::getSize(int id)
{
	
	if(id<devicesFound)
	{
		return VDList[id] ->videoSize;
	}
	
	return 0;
	
}





bool videoInput::grabFrame(int id, unsigned char * buffer)
{


	if(id<devicesFound)
	{
		
		if(VDList[id]->readyToCapture)
		{	
			
			HRESULT hr = VDList[id]->pGrabber->GetCurrentBuffer(&VDList[id]->cbBuffer, (long*)buffer);
			
			if(hr==S_OK){
				
				flipRGB((void*)buffer, getWidth(id), getHeight(id));
				return true;
				
			}else{
				printf("Filter: Error Grabbing frame. ");
				return false;
			}
		}else{
			return false;
		}
	}

	return false;
}




int videoInput::start(int deviceID, videoDevice *VD)

{

  
    CAPTURE_MODE   = PIN_CATEGORY_CAPTURE;
	WCHAR dName[255];
	memset(dName, 0, sizeof(char)*255);

	HRESULT hr;

	// CREATE THE GRAPH BUILDER //
    // Create the filter graph manager and query for interfaces.
    hr = CoCreateInstance(CLSID_CaptureGraphBuilder2, NULL, CLSCTX_INPROC_SERVER, IID_ICaptureGraphBuilder2, (void **)&VD->pCaptureGraph);
    if (FAILED(hr))	// FAILED is a macro that tests the return value
    {
        printf("ERROR - Could not create the Filter Graph Manager.");
        return hr;
    }


	//FITLER GRAPH MANAGER//
    // Create the Filter Graph Manager.
    hr = CoCreateInstance(CLSID_FilterGraph, 0, CLSCTX_INPROC_SERVER,IID_IGraphBuilder, (void**)&VD->pGraph);
    if (FAILED(hr))
    {
    	return hr;
    }
    hr = VD->pCaptureGraph->SetFiltergraph(VD->pGraph);
    if (FAILED(hr))
    {
    	return hr;
    }

	//MEDIA CONTROL (START/STOPS STREAM)//
	// Using QueryInterface on the graph builder, 
    // Get the Media Control object.
    hr = VD->pGraph->QueryInterface(IID_IMediaControl, (void **)&VD->pControl);
    if (FAILED(hr))
    {
        printf("ERROR - Could not create the Media Control object.");
        VD->pGraph->Release();	// Clean up after ourselves.
		CoUninitialize();  // And uninitalize COM
        return hr;
        
    }
    
	//FIND VIDEO DEVICE//
	//gets the device specified by the second argument.  
	hr = getDevice(&VD->pVideoInputFilter, deviceID, dName);
	if (SUCCEEDED(hr)){
		hr = VD->pGraph->AddFilter(VD->pVideoInputFilter, dName);
	}else{
        printf("ERROR - Could not find specified video device.");
        VD->pGraph->Release();	// Clean up after ourselves.
		CoUninitialize();  // And uninitalize COM
        return hr;		
	}


	//LOOK FOR PREVIEW PIN IF THERE IS NONE THEN WE USE CAPTURE PIN AND THEN SMART TEE TO PREVIEW
	IAMStreamConfig *streamConfTest = NULL;
    hr = VD->pCaptureGraph->FindInterface(&PIN_CATEGORY_PREVIEW, &MEDIATYPE_Video, VD->pVideoInputFilter, IID_IAMStreamConfig, (void **)&streamConfTest);		
	if(FAILED(hr)){
		printf("SETUP: Couldn't find preview pin using SmartTee\n");
	}else{
		 CAPTURE_MODE = PIN_CATEGORY_PREVIEW;
		 streamConfTest->Release();
	}


	//CROSSBAR (SELECT PHYSICAL INPUT TYPE)//
	//my own function that checks to see if the device can support a crossbar and if so it routes it.  
	//webcams tend not to have a crossbar so this function will also detect a webcams and not apply the crossbar 
	if(VD->useCrossbar) routeCrossbar(&VD->pCaptureGraph, &VD->pVideoInputFilter, VD->connection, CAPTURE_MODE);
	
	//SET FORMAT AND SIZE//
	//needs to be local because the sampleGrabber needs the same settings
	IAMStreamConfig *streamConf;
	
	int attemptWidth = VD->width;
	int attemptHeight = VD->height;
	int tmpWidth, tmpHeight = 0;
	    
	//we do this because webcams don't have a preview mode
	hr = VD->pCaptureGraph->FindInterface(&CAPTURE_MODE, &MEDIATYPE_Video, VD->pVideoInputFilter, IID_IAMStreamConfig, (void **)&streamConf);
	if(FAILED(hr)) return hr;
	hr = streamConf->GetFormat(&VD->pAmMediaType);
	if(FAILED(hr)) return hr;
	
	VD->pAmMediaType->formattype = FORMAT_VideoInfo;
	VD->pAmMediaType->majortype  = MEDIATYPE_Video; 
	VD->pAmMediaType->subtype    = MEDIASUBTYPE_RGB24; 

	if(hr == S_OK)
	{
			
		VIDEOINFOHEADER *pVih =  reinterpret_cast<VIDEOINFOHEADER*>(VD->pAmMediaType->pbFormat);
		printf("SETUP: Default Format is set to %i by %i \n",  HEADER(pVih)->biWidth,  HEADER(pVih)->biHeight);
		
		//store current size
		tmpWidth  = HEADER(pVih)->biWidth;
		tmpHeight = HEADER(pVih)->biHeight;			
		
		if(VD->tryDiffSize)
		{
			//assign new size	
			HEADER(pVih)->biWidth  = attemptWidth;
			HEADER(pVih)->biHeight = attemptHeight;	

			//try new size	
			hr = streamConf->SetFormat(VD->pAmMediaType);		  
			
			if(hr == S_OK){	
				//USING SPECIFIED CAPTURE SIZE - ALL GOOD
				tmpWidth  =  HEADER(pVih)->biWidth;
				tmpHeight =  HEADER(pVih)->biHeight;
				printf("SETUP: Trying different capture size %i by %i \n", attemptWidth, attemptHeight);
			}else{
				//ERROR CAN'T USE THAT CAPTURE SIZE REVERT TO OLD SIZE 
				HEADER(pVih)->biWidth  = tmpWidth;
				HEADER(pVih)->biHeight = tmpHeight;	
				streamConf->SetFormat(VD->pAmMediaType);		  
				printf("SETUP: Capture Device doesn't support %i by %i.  Reverting to %i by %i\n", attemptWidth, attemptHeight, tmpWidth, tmpHeight);
			}		
		}
		
		VD->width  = tmpWidth;  //assign the buffer size to our global width and height variables.
		VD->height = tmpHeight;
		
	}else printf("ERROR: Problem setting video size\n");		

	//SAMPLE GRABBER (ALLOWS US TO GRAB THE BUFFER)//
	IBaseFilter *pGrabberF = NULL;    //Grabber Filter
	// Create the Sample Grabber.
	hr = CoCreateInstance(CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER,IID_IBaseFilter, (void**)&pGrabberF);
	if (FAILED(hr))
	{
		printf("Could not Create Sample Grabber - CoCreateInstance()");
		return hr;
	}
	
	hr = VD->pGraph->AddFilter(pGrabberF, L"Sample Grabber");
	if (FAILED(hr))
	{
		printf("Could not add Sample Grabber - AddFilter()");
		return hr;
	}
	
	pGrabberF->QueryInterface(IID_ISampleGrabber, (void**)&VD->pGrabber);
	
	//Set Params - One Shot should be false unless you want to capture just one buffer
	hr = VD->pGrabber->SetOneShot(FALSE);
	hr = VD->pGrabber->SetBufferSamples(TRUE);	

	//get video properties from the stream's mediatype and apply to the grabber (otherwise we don't get an RGB image)	
	hr = VD->pGrabber->SetMediaType(VD->pAmMediaType);
	if(FAILED(hr)) return hr;

	streamConf->Release();

	//NULL RENDERER//
	//used to give the video stream somewhere to go to.  
	IBaseFilter *pDestFilter = NULL;    //Null Renderer Filter
	hr = CoCreateInstance(CLSID_NullRenderer, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)(&pDestFilter));
	if(FAILED(hr)) return hr;
	hr = VD->pGraph->AddFilter(pDestFilter, L"NullRenderer");	
	if(FAILED(hr)) return hr;

	//RENDER STREAM//
	//This is where the stream gets put together. 
	IBaseFilter *pIntermediate = NULL;
	hr = VD->pCaptureGraph->RenderStream(&PIN_CATEGORY_PREVIEW, &MEDIATYPE_Video, VD->pVideoInputFilter, pGrabberF, pDestFilter);

    if (SUCCEEDED(hr))
    {       
        // Run the graph
        hr = VD->pControl->Run();
		if(FAILED(hr)) return hr;
		
		VD->cbBuffer = 0;
		int count = 0;
		int sleepTime = 10;
		//This makes sure that it has returned correct size sometimes
		//it return zero even though it gives us S_OK
		while(hr!=S_OK||VD->cbBuffer==0){
			
			hr = VD->pGrabber->GetCurrentBuffer(&VD->cbBuffer, NULL);
			
			if(VD->cbBuffer==0&&hr==S_OK){
				printf("Filter: Cannot get buffer size. Trying Again\n"); 
				continue;
			}	

			switch(hr){
				
			  	case S_OK:                 printf("FILTER: All Good - Buffer Size is %i bytes\n", VD->cbBuffer); break;
			  	case E_OUTOFMEMORY:        printf("FILTER: OutOfMemory \n"); break;
				case VFW_E_NOT_CONNECTED:  printf("FILTER: Not Connected\n"); break;
			 	case VFW_E_WRONG_STATE:    count++; break;
			  	default:
			 	break;
		 	}
		 	
		 	Sleep(10);
		 	
		 }	
		 
		printf("STATUS: You can now grab my frame :)\n\n");
		
		// Set the Buffer size
		VD->pBuffer = new char[VD->cbBuffer];
		memset(VD->pBuffer,0,sizeof(char)*VD->cbBuffer);
		VD->videoSize = VD->cbBuffer;
		VD->readyToCapture = true;   		
  		
        //printf("Preview Stops\n");
    	SaveGraphFile(VD->pGraph, L"sendWithBugReport.grf");
    	
    	
    }
    else
    {
   
        printf("Could not connect pins - RenderStream()\n");
        VD->pVideoInputFilter->Release();       
    
	}
         

	return 0;

}





videoInput::~videoInput(){
	
   CoUninitialize();
	
}


 
void videoInput::showSettingsWindow(int id)
{ 

	if(id<devicesFound)
	{
		ShowFilterPropertyPages(VDList[id]->pVideoInputFilter);
	}
	
}
   
 

// A very useful bit of code 
// Stolen from the DX9 SDK
HRESULT videoInput::AddFilterByCLSID(
    IGraphBuilder *pGraph,  // Pointer to the Filter Graph Manager.
    const GUID& clsid,      // CLSID of the filter to create.
    LPCWSTR wszName,        // A name for the filter.
    IBaseFilter **ppF)      // Receives a pointer to the filter.
{
    if (!pGraph || ! ppF) return E_POINTER;
    *ppF = 0;
    IBaseFilter *pF = 0;
    HRESULT hr = CoCreateInstance(clsid, 0, CLSCTX_INPROC_SERVER,
        IID_IBaseFilter, reinterpret_cast<void**>(&pF));
    if (SUCCEEDED(hr))
    {
        hr = pGraph->AddFilter(pF, wszName);
        if (SUCCEEDED(hr))
            *ppF = pF;
        else
            pF->Release();
    }
    return hr;
}

   
// Enumerate all of the video input devices
// Return the filter with a matching friendly name
HRESULT videoInput::getDevice(IBaseFilter** gottaFilter, int deviceId, WCHAR * deviceName)
{
	BOOL done = false;
	int deviceCounter = 0;

	// Create the System Device Enumerator.
	ICreateDevEnum *pSysDevEnum = NULL;
	HRESULT hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER,
		IID_ICreateDevEnum, (void **)&pSysDevEnum);
	if (FAILED(hr))
	{
		return hr;
	}

	// Obtain a class enumerator for the video input category.
	IEnumMoniker *pEnumCat = NULL;
	hr = pSysDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pEnumCat, 0);

	if (hr == S_OK) 
	{
		// Enumerate the monikers.
		IMoniker *pMoniker = NULL;
		ULONG cFetched;
		while ((pEnumCat->Next(1, &pMoniker, &cFetched) == S_OK) && (!done))
		{
			if(deviceCounter == deviceId)
			{
				// Bind the first moniker to an object
				IPropertyBag *pPropBag;
				hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, 
					(void **)&pPropBag);
				if (SUCCEEDED(hr))
				{
					// To retrieve the filter's friendly name, do the following:
					VARIANT varName;
					VariantInit(&varName);
					hr = pPropBag->Read(L"FriendlyName", &varName, 0);
					if (SUCCEEDED(hr))
					{				
						int count = 0;
						char buffer[255];
						memset(buffer, 0, 255 * sizeof(char));
						
	                	while( varName.bstrVal[count] != 0x00 ) {
	                  		 buffer[count] = varName.bstrVal[count];
	                  		 deviceName[count] = varName.bstrVal[count];
	                  		 count++;
	                 	}
	                	WCHAR * dName = new WCHAR[count];
		                memcpy(dName,buffer,sizeof(WCHAR)*(count));
		                printf("SETUP: Using Device %i: %s \n",deviceId, dName);
		                delete(dName);                    			
						// We found it, so send it back to the caller
						hr = pMoniker->BindToObject(NULL, NULL, IID_IBaseFilter, (void**) gottaFilter);
						done = true;
					}
					VariantClear(&varName);	
					pPropBag->Release();
					pMoniker->Release();
				}
			}
			deviceCounter++;
		}
		pEnumCat->Release();
	}
	pSysDevEnum->Release();
	if (done) {
		return hr;	// found it, return native error
	} else {
		return VFW_E_NOT_FOUND;	// didn't find it error
	}
}
 
 
 
 
   
// Enumerate all of the video input devices
// Return the filter with a matching friendly name
HRESULT videoInput::GetVideoInputFilter(IBaseFilter** gottaFilter, wchar_t* matchName)
{
	BOOL done = false;

	// Create the System Device Enumerator.
	ICreateDevEnum *pSysDevEnum = NULL;
	HRESULT hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER,
		IID_ICreateDevEnum, (void **)&pSysDevEnum);
	if (FAILED(hr))
	{
		return hr;
	}

	// Obtain a class enumerator for the video input category.
	IEnumMoniker *pEnumCat = NULL;
	hr = pSysDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pEnumCat, 0);

	if (hr == S_OK) 
	{
		// Enumerate the monikers.
		IMoniker *pMoniker = NULL;
		ULONG cFetched;
		while ((pEnumCat->Next(1, &pMoniker, &cFetched) == S_OK) && (!done))
		{
			// Bind the first moniker to an object
			IPropertyBag *pPropBag;
			hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, 
				(void **)&pPropBag);
			if (SUCCEEDED(hr))
			{
				// To retrieve the filter's friendly name, do the following:
				VARIANT varName;
				VariantInit(&varName);
				hr = pPropBag->Read(L"FriendlyName", &varName, 0);
				if (SUCCEEDED(hr))
				{
					wprintf(L"Testing Video Input Device: %s\n", varName.bstrVal);

					// Do a comparison, find out if it's the right one
					if (wcsncmp(varName.bstrVal, matchName, 
						wcslen(matchName)) == 0) {

						// We found it, so send it back to the caller
						hr = pMoniker->BindToObject(NULL, NULL, IID_IBaseFilter, (void**) gottaFilter);
						done = true;
					}
				}
				VariantClear(&varName);	
				pPropBag->Release();
			}
			pMoniker->Release();
		}
		pEnumCat->Release();
	}
	pSysDevEnum->Release();
	if (done) {
		return hr;	// found it, return native error
	} else {
		return VFW_E_NOT_FOUND;	// didn't find it error
	}
}

  
   
// Show the property pages for a filter
// This is stolen from the DX9 SDK
HRESULT videoInput::ShowFilterPropertyPages(IBaseFilter *pFilter) 
{

	ISpecifyPropertyPages *pProp;
	HRESULT hr = pFilter->QueryInterface(IID_ISpecifyPropertyPages, (void **)&pProp);
	if (SUCCEEDED(hr)) 
	{
		// Get the filter's name and IUnknown pointer.
		FILTER_INFO FilterInfo;
		hr = pFilter->QueryFilterInfo(&FilterInfo); 
		IUnknown *pFilterUnk;
		pFilter->QueryInterface(IID_IUnknown, (void **)&pFilterUnk);

		// Show the page. 
		CAUUID caGUID;
		pProp->GetPages(&caGUID);
		pProp->Release();
		OleCreatePropertyFrame(
			NULL,                   // Parent window
			0, 0,                   // Reserved
			FilterInfo.achName,     // Caption for the dialog box
			1,                      // Number of objects (just the filter)
			&pFilterUnk,            // Array of object pointers. 
			caGUID.cElems,          // Number of property pages
			caGUID.pElems,          // Array of property page CLSIDs
			0,                      // Locale identifier
			0, NULL                 // Reserved
		);

		// Clean up.
		pFilterUnk->Release();
		FilterInfo.pGraph->Release(); 
		CoTaskMemFree(caGUID.pElems);
	}
	return hr;
}
   

// This code was also brazenly stolen from the DX9 SDK
// Pass it a file name in wszPath, and it will save the filter graph to that file.
HRESULT videoInput::SaveGraphFile(IGraphBuilder *pGraph, WCHAR *wszPath) 
{
    const WCHAR wszStreamName[] = L"ActiveMovieGraph"; 
    HRESULT hr;
    IStorage *pStorage = NULL;

	// First, create a document file which will hold the GRF file
	hr = StgCreateDocfile(
        wszPath,
        STGM_CREATE | STGM_TRANSACTED | STGM_READWRITE | STGM_SHARE_EXCLUSIVE,
        0, &pStorage);
    if(FAILED(hr)) 
    {
        return hr;
    }

	// Next, create a stream to store.
    IStream *pStream;
    hr = pStorage->CreateStream(
		wszStreamName,
        STGM_WRITE | STGM_CREATE | STGM_SHARE_EXCLUSIVE,
        0, 0, &pStream);
    if (FAILED(hr)) 
    {
        pStorage->Release();    
        return hr;
    }

	// The IPersistStream converts a stream into a persistent object.
    IPersistStream *pPersist = NULL;
    pGraph->QueryInterface(IID_IPersistStream, reinterpret_cast<void**>(&pPersist));
    hr = pPersist->Save(pStream, TRUE);
    pStream->Release();
    pPersist->Release();
    if (SUCCEEDED(hr)) 
    {
        hr = pStorage->Commit(STGC_DEFAULT);
    }
    pStorage->Release();
    return hr;
}


   
HRESULT videoInput::routeCrossbar(ICaptureGraphBuilder2 **ppBuild, IBaseFilter **pVidInFilter, int conType, GUID captureMode)
{
   
    
    //create local ICaptureGraphBuilder2
	ICaptureGraphBuilder2 *pBuild = NULL;
 	pBuild = *ppBuild;
 	
 	//create local IBaseFilter
 	IBaseFilter *pVidFilter = NULL;
 	pVidFilter = * pVidInFilter;
       
	// Search upstream for a crossbar.
	IAMCrossbar *pXBar1 = NULL;
	HRESULT hr = pBuild->FindInterface(&LOOK_UPSTREAM_ONLY, NULL, pVidFilter,
	        IID_IAMCrossbar, (void**)&pXBar1);
	if (SUCCEEDED(hr)) 
	{
	    
	    bool foundDevice = false;
	    
	    printf("SETUP: You are not a webcam! Setting Crossbar.\n");
	    pXBar1->Release();
	    
	    IAMCrossbar *Crossbar;
	    hr = pBuild->FindInterface(&captureMode, &MEDIATYPE_Interleaved, pVidFilter, IID_IAMCrossbar, (void **)&Crossbar);
	    
	    if(hr != NOERROR){
	        hr = pBuild->FindInterface(&captureMode, &MEDIATYPE_Video, pVidFilter, IID_IAMCrossbar, (void **)&Crossbar);
		}

		LONG lInpin, lOutpin;
		hr = Crossbar->get_PinCounts(&lOutpin , &lInpin); 
				
		BOOL IPin=TRUE; LONG pIndex=0 , pRIndex=0 , pType=0;
		
		while( pIndex < lInpin)
		{
			hr = Crossbar->get_CrossbarPinInfo( IPin , pIndex , &pRIndex , &pType); 
		
			if( pType == conType){
					printf("SETUP: Found Physical Interface");				
					
					switch(conType){

						case PhysConn_Video_Composite:
							printf(" - Composite\n");
							break;
						case PhysConn_Video_SVideo:	
							printf(" - S-Video\n");	
							break;
						case PhysConn_Video_Tuner:
							printf(" - Tuner\n");
							break;
						case PhysConn_Video_USB:
							 printf(" - USB\n");
							break;	
						case PhysConn_Video_1394:
							printf(" - Firewire\n");
							break;
					}				
							
				foundDevice = true;
				break;
			}
			pIndex++;
		
		}
		
		if(foundDevice){
			BOOL OPin=FALSE; LONG pOIndex=0 , pORIndex=0 , pOType=0;
			while( pOIndex < lOutpin)
			{
				hr = Crossbar->get_CrossbarPinInfo( OPin , pOIndex , &pORIndex , &pOType); 
				if( pOType == PhysConn_Video_VideoDecoder)
					break;
			}
			Crossbar->Route(pOIndex,pIndex); 
		}else{
			printf("SETUP: Didn't find specified Physical Connection type. Using Defualt. \n");	
		}
		
			
	    Crossbar->Release();
	    pXBar1->Release();

	}else{
		printf("SETUP: You are a webcam! No Crossbar needed.\n");
		return hr;
	}
		
}
   
//works but needs to keep the AM_MEDIA_TYPE global so not using for now  
HRESULT videoInput::setFormat(ICaptureGraphBuilder2 **ppBuild, IBaseFilter **pVidInFilter,  GUID majorType, GUID subType, GUID captureMode)
{
   
    //create local ICaptureGraphBuilder2
	ICaptureGraphBuilder2 *pBuild = NULL;
 	pBuild = *ppBuild;
 	
 	//create local IBaseFilter
 	IBaseFilter *pVidFilter = NULL;
 	pVidFilter = * pVidInFilter;
 	
	AM_MEDIA_TYPE  *mt;
	IAMStreamConfig *streamConf;
	HRESULT hr;
	    
	//we do this because webcams don't have a preview mode
	hr = pBuild->FindInterface(&captureMode, &MEDIATYPE_Video, pVidFilter, IID_IAMStreamConfig, (void **)&streamConf);
	hr = streamConf->GetFormat(&mt);

	if(hr == S_OK){
			
		mt->formattype = FORMAT_VideoInfo;
		mt->majortype  = majorType; 
		mt->subtype    = subType; 	
	}else{
	
		printf("ERROR: Couldn't set format\n");
	
	}
	
	streamConf->Release();	
	return hr;
}
   
   
   
//works but needs to keep the AM_MEDIA_TYPE global so not using for now  
HRESULT videoInput::setSize(ICaptureGraphBuilder2 **ppBuild, IBaseFilter **pVidInFilter, int *w, int *h, bool setNewSize, GUID captureMode)
{
   
    //create local ICaptureGraphBuilder2
	ICaptureGraphBuilder2 *pBuild = NULL;
 	pBuild = *ppBuild;
 	
 	//create local IBaseFilter
 	IBaseFilter *pVidFilter = NULL;
 	pVidFilter = * pVidInFilter;
 	
	IAMStreamConfig *streamConf;
	AM_MEDIA_TYPE  *mt;
	
	HRESULT hr;
	
	int attemptWidth = *w;
	int attemptHeight = *h;
	int tmpWidth, tmpHeight = 0;
	    
	//we do this because webcams don't have a preview mode
	hr = pBuild->FindInterface(&captureMode, &MEDIATYPE_Video, pVidFilter, IID_IAMStreamConfig, (void **)&streamConf);
	hr = streamConf->GetFormat(&mt);

	if(hr == S_OK)
	{
		
		VIDEOINFOHEADER *pVih =  reinterpret_cast<VIDEOINFOHEADER*>(mt->pbFormat);
		printf("SETUP: Default Format is set to %i by %i \n",  HEADER(pVih)->biWidth,  HEADER(pVih)->biHeight);
		
		//store current size
		tmpWidth  = HEADER(pVih)->biWidth;
		tmpHeight = HEADER(pVih)->biHeight;			
		
		if(setNewSize)
		{
			
			//assign new size	
			HEADER(pVih)->biWidth  = attemptWidth;
			HEADER(pVih)->biHeight = attemptHeight;	
			
			//try new size	
			hr = streamConf->SetFormat(mt);		  
			
			if(hr == S_OK){	
				
				//USING SPECIFIED CAPTURE SIZE - ALL GOOD
				
				tmpWidth  =  HEADER(pVih)->biWidth;
				tmpHeight =  HEADER(pVih)->biHeight;
				printf("SETUP: Trying different capture size %i by %i \n", attemptWidth, attemptHeight);
				
				
			}else{
				
				//ERROR CAN'T USE THAT CAPTURE SIZE REVERT TO OLD SIZE 

				HEADER(pVih)->biWidth  = tmpWidth;
				HEADER(pVih)->biHeight = tmpHeight;	
				streamConf->SetFormat(mt);		  
				
				printf("SETUP: Capture Device doesn't support %i by %i.  Reverting to %i by %i\n", attemptWidth, attemptHeight, tmpWidth, tmpHeight);
			}		
								 	
		}
		
		*w = tmpWidth;
		*h = tmpHeight;
		
	}else{
	
		printf("ERROR: Problem setting video size\n");
		
	}

	streamConf->Release();	
	return hr;
}
   
   
   
   
void videoInput::flipRGB(void* buffer, int w, int h)  // Flips The Red And Blue Bytes
{

	int totalSize = w*h;
	void* b = buffer;// Pointer To The Buffer
	__asm// Assembler Code To Follow
	{
	mov ecx, totalSize// Set Up A Counter (Dimensions Of Memory Block)
	mov ebx, b// Points ebx To Our Data (b)
	label:// Label Used For Looping
	mov al,[ebx+0]// Loads Value At ebx Into al
	mov ah,[ebx+2]// Loads Value At ebx+2 Into ah
	mov [ebx+2],al// Stores Value In al At ebx+2
	mov [ebx+0],ah// Stores Value In ah At ebx

	add ebx,3// Moves Through The Data By 3 Bytes
	dec ecx// Decreases Our Loop Counter
	jnz label// If Not Zero Jump Back To Label
	}
}
   
   
   
