#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <windows.h>
	
//////////////////////////////////////////////////////////
//Written by Theodore Watson - theo.watson@gmail.com    //
//Do whatever you want with this code but if you find   //
//a bug or make an improvement I would love to know!    //
//////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
//Right now this is a simple class that allows you to   //
//list and capture from directShow video capture devices//
////////////////////////////////////////////////////////// 

//VERSION 0.15
	
	
//CHANGES
//1) Now should be almost impossible to cause a crash 
//2) Should also no longer lag on slow machines, instead it drops frames to keep up
//3) Can call listDevices() before creating an instance of the class
//4) #defines for the connection types ie VI_S_VIDEO
//5) Can specify almost any size
//6) Only need one videoInput object to handle multiple cameras.

//ISSUES:
//Need modified streams.h for it to compile in codewarrior
//see bottom of this file for correct streams.h file (incase you lose it)

//NOTES:
//Direct Show includes are in the .cpp file so they don't 
//need to be inlcuded to use this lib.  


/* Example useage
		
			
			//ONE CAMERA
			
			videoInput * VI  = new videoInput();
			//VI  ->setPhyCon(VI_S_VIDEO);             //If you need to change the input
			//VI  ->setCaptureSize(0,320,240);		   //if you need a size other than the default
			VI  ->setup(1); //try to setup two cameras.

			unsigned char * frame   = new unsigned char[VI->getSize(0)]; //set the buffer to the size we are capturing at
			while(running)
			{			
				if(VI->grabFrame(0, frame))  //do something with the image
			}
			
			//use VI->getWidth(0) VI->getHeight(0) to get image dimensions,  VI->getSize(0) for image size 

			
			//TWO CAMERAS
			
			videoInput * VI  = new videoInput();
			VI  ->setCaptureSize(0,320,240);		   //Only use if you need a different size than the default
			VI  ->setCaptureSize(1,320,240);	       //Only use if you need a different size than the default
			VI  ->setup(2); //try to setup two cameras.

			unsigned char * frame   = new unsigned char[VI->getSize(0)]; //set the buffer to the size we are capturing at
			unsigned char * frame2  = new unsigned char[VI->getSize(1)]; //set the buffer to the size we are capturing at


			while(running)
			{			
				if(VI->grabFrame(0, frame))  //do something with the image
				if(VI->grabFrame(1, frame2)) //do something with the image
			}


*/



////////////////////////////////////////   VIDEO DEVICE   ///////////////////////////////////

#ifndef _VIDEODEVICE
#define _VIDEODEVICE


class ICaptureGraphBuilder2;
class IGraphBuilder;
class IBaseFilter;
class IAMCrossbar;
class IMediaControl;
class ISampleGrabber;
class   _AMMediaType;
typedef _AMMediaType AM_MEDIA_TYPE;

class videoDevice{

	
	public:
		 
		 videoDevice();
		~videoDevice();
		
		
		int videoSize;
		int width;
		int height;
		
		ICaptureGraphBuilder2 *pCaptureGraph;	// Capture graph builder object
		IGraphBuilder *pGraph;					// Graph builder object
	    IMediaControl *pControl;				// Media control object
		IBaseFilter *pVideoInputFilter;  		// Video Capture filter
		ISampleGrabber * pGrabber;    			// Grabs frame
		AM_MEDIA_TYPE * pAmMediaType;
		
		char *pBuffer;		
		long cbBuffer;
		
		bool tryDiffSize;
		bool useCrossbar;
		bool readyToCapture;
		int  connection;
};

#endif

////////////////////////////////////////////////////////////////////////////////////////////




//////////////////////////////////////   VIDEO INPUT   /////////////////////////////////////


//allows us to directShow classes here with the includes in the cpp
class ICaptureGraphBuilder2;
class IGraphBuilder;
class IBaseFilter;
class IAMCrossbar;
class IMediaControl;
class ISampleGrabber;

//defines for setPhyCon
#define VI_COMPOSITE 0
#define VI_S_VIDEO   1
#define VI_TUNER     2
#define VI_USB       3	

#define MAX_CAMERAS  20


static bool comInit;


class videoInput{

	public:
		videoInput();
		~videoInput();
		
		static int listDevices();
		
		//functions in order they should be used.
		void setPhyCon(int deviceID, int conn);                   //OPTIONAL select connection type ( 0:composite, 1:s-video, 2:tuner)  For USB and Firewire don't call this function
		void setCaptureSize(int deviceID, int w, int h);          //OPTIONAL only use if you want to capture at a smaller resolution than the default one.  ie use 320x240 instead of 640x480
		int  setup(int numDevices);
		
		bool grabFrame(int deviceID, unsigned char * buffer);     //three channel RGB image
		void showSettingsWindow(int deviceID);
		
		int getWidth(int deviceID);
		int getHeight(int deviceID);
		int getSize(int deviceID);

	private:		
		int  listDevicesPrivate();
		int  start(int deviceID, videoDevice * VD);                   
		bool InitCaptureGraphBuilder(IGraphBuilder **ppGraph,  ICaptureGraphBuilder2 **ppBuild  );
		HRESULT getDevice(IBaseFilter **pSrcFilter, int deviceID, WCHAR * deviceName);
		bool setCrossbar(ICaptureGraphBuilder2 **ppBuild);
		HRESULT GetVideoInputFilter(IBaseFilter** gottaFilter, wchar_t* matchName);
		HRESULT ShowFilterPropertyPages(IBaseFilter *pFilter);
		HRESULT AddFilterByCLSID(IGraphBuilder *pGraph, const GUID& clsid, LPCWSTR wszName, IBaseFilter **ppF); 
		HRESULT SaveGraphFile(IGraphBuilder *pGraph, WCHAR *wszPath);
		HRESULT routeCrossbar(ICaptureGraphBuilder2 **ppBuild, IBaseFilter **pVidInFilter, int conType, GUID captureMode);
		HRESULT setFormat(ICaptureGraphBuilder2 **ppBuild, IBaseFilter **pVidInFilter, GUID majorType, GUID subType, GUID captureMode);
		HRESULT setSize(ICaptureGraphBuilder2 **ppBuild, IBaseFilter **pVidInFilter, int *w, int *h, bool setNewSize, GUID captureMode);
		void flipRGB(void *buffer, int width, int height);
		
		int  connection;
		int  devicesFound;
		
		GUID CAPTURE_MODE;
		videoDevice * VDList[MAX_CAMERAS];
		
}; 
  
  
/////////////////////////////////////////////////////////////////////////////
//IAMCrossbar Stuff 
//- Borrowed and adapted from CCaptureVideo::StartTVTuner in CaptureVideo.cpp
//--------------------------------------------------------------------------//
// Copyright DILLIP KUMAR KARA 2004
// You may do whatever you want with this code, as long as you include this
// copyright notice in your implementation files.
// Comments and bug Reports: codeguru_bank@yahoo.com
//--------------------------------------------------------------------------//
 
 
 
//Modified streams.h file 
/*

//------------------------------------------------------------------------------
// File: Streams.h
//
// Desc: DirectShow base classes - defines overall streams architecture.
//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------------------------


#ifndef __STREAMS__
#define __STREAMS__

#ifdef	_MSC_VER
// disable some level-4 warnings, use #pragma warning(enable:###) to re-enable
#pragma warning(disable:4100) // warning C4100: unreferenced formal parameter
#pragma warning(disable:4127) // warning C4127: conditional expression is constant
#pragma warning(disable:4189) // warning C4189: local variable is initialized but not referenced
#pragma warning(disable:4201) // warning C4201: nonstandard extension used : nameless struct/union
#pragma warning(disable:4511) // warning C4511: copy constructor could not be generated
#pragma warning(disable:4512) // warning C4512: assignment operator could not be generated
#pragma warning(disable:4514) // warning C4514: unreferenced inline function has been removed
#pragma warning(disable:4710) // warning C4710: 'function' not inlined

#if _MSC_VER>=1100

#define AM_NOVTABLE __declspec(novtable)
#else
#define AM_NOVTABLE
#endif
#else                                    //new line
#define AM_NOVTABLE    //new line
#endif // MSC_VER

// Because of differences between Visual C++ and older Microsoft SDKs,
// you may have defined _DEBUG without defining DEBUG.  This logic
// ensures that both will be set if Visual C++ sets _DEBUG.
#ifdef _DEBUG
#ifndef DEBUG
#define DEBUG
#endif
#endif


#include <windows.h>
#include <windowsx.h>
#include <olectl.h>
#include <ddraw.h>

// Disable warning message for C4201 - use of nameless struct/union
// Otherwise, strmif.h will generate warnings for Win32 debug builds
#pragma warning( disable : 4201 )  

#include <mmsystem.h>

#ifndef NUMELMS
   #define NUMELMS(aa) (sizeof(aa)/sizeof((aa)[0]))
#endif

///////////////////////////////////////////////////////////////////////////
// The following definitions come from the Platform SDK and are required if
// the applicaiton is being compiled with the headers from Visual C++ 6.0.
///////////////////////////////////////////////////////////////////////////
#ifndef InterlockedExchangePointer
	#define InterlockedExchangePointer(Target, Value) \
   (PVOID)InterlockedExchange((PLONG)(Target), (LONG)(Value))
#endif

#ifndef _WAVEFORMATEXTENSIBLE_
#define _WAVEFORMATEXTENSIBLE_
typedef struct {
    WAVEFORMATEX    Format;
    union {
        WORD wValidBitsPerSample;       // bits of precision  //
        WORD wSamplesPerBlock;          // valid if wBitsPerSample==0 //
        WORD wReserved;                 // If neither applies, set to zero. //
    } Samples;
    DWORD           dwChannelMask;      // which channels are //
                                        // present in stream  //
    GUID            SubFormat;
} WAVEFORMATEXTENSIBLE, *PWAVEFORMATEXTENSIBLE;
#endif // !_WAVEFORMATEXTENSIBLE_

#if !defined(WAVE_FORMAT_EXTENSIBLE)
#define  WAVE_FORMAT_EXTENSIBLE                 0xFFFE
#endif // !defined(WAVE_FORMAT_EXTENSIBLE)

#ifndef GetWindowLongPtr
  #define GetWindowLongPtrA   GetWindowLongA
  #define GetWindowLongPtrW   GetWindowLongW
  #ifdef UNICODE
    #define GetWindowLongPtr  GetWindowLongPtrW
  #else
    #define GetWindowLongPtr  GetWindowLongPtrA
  #endif // !UNICODE
#endif // !GetWindowLongPtr

#ifndef SetWindowLongPtr
  #define SetWindowLongPtrA   SetWindowLongA
  #define SetWindowLongPtrW   SetWindowLongW
  #ifdef UNICODE
    #define SetWindowLongPtr  SetWindowLongPtrW
  #else
    #define SetWindowLongPtr  SetWindowLongPtrA
  #endif // !UNICODE
#endif // !SetWindowLongPtr

#ifndef GWLP_WNDPROC
  #define GWLP_WNDPROC        (-4)
#endif
#ifndef GWLP_HINSTANCE
  #define GWLP_HINSTANCE      (-6)
#endif
#ifndef GWLP_HWNDPARENT
  #define GWLP_HWNDPARENT     (-8)
#endif
#ifndef GWLP_USERDATA
  #define GWLP_USERDATA       (-21)
#endif
#ifndef GWLP_ID
  #define GWLP_ID             (-12)
#endif
#ifndef DWLP_MSGRESULT
  #define DWLP_MSGRESULT  0
#endif
#ifndef DWLP_DLGPROC 
  #define DWLP_DLGPROC    DWLP_MSGRESULT + sizeof(LRESULT)
#endif
#ifndef DWLP_USER
  #define DWLP_USER       DWLP_DLGPROC + sizeof(DLGPROC)
#endif
///////////////////////////////////////////////////////////////////////////
// End Platform SDK definitions
///////////////////////////////////////////////////////////////////////////


#pragma warning(disable:4201) // warning C4201: nonstandard extension used : nameless struct/union
#include <strmif.h>     // Generated IDL header file for streams interfaces

#include <reftime.h>    // Helper class for REFERENCE_TIME management
#include <wxdebug.h>    // Debug support for logging and ASSERTs
#include <amvideo.h>    // ActiveMovie video interfaces and definitions
//include amaudio.h explicitly if you need it.  it requires the DirectX SDK.
//#include <amaudio.h>    // ActiveMovie audio interfaces and definitions
#include <wxutil.h>     // General helper classes for threads etc
#include <combase.h>    // Base COM classes to support IUnknown
#include <dllsetup.h>   // Filter registration support functions
#include <measure.h>    // Performance measurement
#include <comlite.h>    // Light weight com function prototypes

#include <cache.h>      // Simple cache container class
#include <wxlist.h>     // Non MFC generic list class
#include <msgthrd.h>	// CMsgThread
#include <mtype.h>      // Helper class for managing media types
#include <fourcc.h>     // conversions between FOURCCs and GUIDs
#include <control.h>    // generated from control.odl
#include <ctlutil.h>    // control interface utility classes
#include <evcode.h>     // event code definitions
#include <amfilter.h>   // Main streams architecture class hierachy
#include <transfrm.h>   // Generic transform filter
#include <transip.h>    // Generic transform-in-place filter
#include <uuids.h>      // declaration of type GUIDs and well-known clsids
#include <source.h>	// Generic source filter
#include <outputq.h>    // Output pin queueing
#include <errors.h>     // HRESULT status and error definitions
#include <renbase.h>    // Base class for writing ActiveX renderers
#include <winutil.h>    // Helps with filters that manage windows
#include <winctrl.h>    // Implements the IVideoWindow interface
#include <videoctl.h>   // Specifically video related classes
#include <refclock.h>	// Base clock class
#include <sysclock.h>	// System clock
#include <pstream.h>    // IPersistStream helper class
#include <vtrans.h>     // Video Transform Filter base class
#include <amextra.h>
#include <cprop.h>      // Base property page class
#include <strmctl.h>    // IAMStreamControl support
#include <edevdefs.h>   // External device control interface defines
#include <audevcod.h>   // audio filter device error event codes

#else
    #ifdef DEBUG
    #pragma message("STREAMS.H included TWICE")
    #endif
#endif // __STREAMS__

*/
 
 